%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% To organize the data from different sub experiments into a big table of
% the following format: (note: to deal with memory overflow, we separately
% store the organized data by each packet type and receiver-id.)
%    receiver-id: id of the packet receiver
%    sender-id:   id of the packet sender
%    pkt-seq-#:   sequence number of the packet
%    is-auto-bitrate:  0: auto bitrate control at the sender 
%                      non-zero: fixed bitrate
%    is-broadcast:     0: broadcast packet
%                      non-zero: id of the unicast-destination
%    pkt-size:         payload size in the # of bytes
%    reception-time:   the time, in microseconds, of packet reception at the receiver
%    ----------
%    link-quality:     link quality from wireless card driver
%    signal-level:    
%    noise-level: 
%    ---------------------
%    distance:    distance between the sender and receiver (feet)
%    x-dist:      distance along x-axis (Data after "Avon Park")
%    y-dist:      distance along y-axis (Data after "Avon Park")
%    ---------------------
%    is-received:         0: yes    -1: no
%    sending-time:        the time, in microseconds, of packet generation at the sender
%    ---------------------
%    transmission-status: success/failure as detected by the sender   1: successs    -1: failure
%    transmission-rate:   transmission bitrate at the sender (for unicast only?)
%    feedback-time:       time when the feedback is received
%    mac-latency:         time taken to send a packet at the MAC layer (microseconds)
%
% Author: Hongwei Zhang (zhangho@cse.ohio-state.edu)
% Last modified: Nov. 8, 2004
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc
clear

%some constants
USE_UNIX_MATLAB = 0; %1; %0: no     1: yes
if ~USE_UNIX_MATLAB
    %rootDir = 'D:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\osu-airport\12-and-6-ft-separation\rawData';    
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\transformedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-0\transformedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-1\transformedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power2\transformedData';
    rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power1\transformedData';
else 
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/osu-airport/12-and-6-ft-separation/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/unicast-0-retry/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/Avon-park/unicast/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/Avon-park/broadcast/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/testbed-attenuator/40db/power-127/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/testbed-attenuator/40db/power-128/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/broadcast/rawData';
    %rootDir ='/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/unicast/row7/rawData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/unicast/otherRows/rawData';
    %rootDir = '/home/6/anish/ft/zhang/NEST-0/Tier-1/Hongwei/ExScalMessaging/LinkMeasurement/exptData/kansei/1/transformedData';
    %rootDir = '/home/6/anish/ft/zhang/NEST-0/Tier-1/Hongwei/ExScalMessaging/LinkMeasurement/exptData/kansei/2/transformedData';
end
%DATA_ORGANIZED = 'link_data_12_and_6_ft'; 
%DATA_ORGANIZED = '1km-135ft-separation';
%DATA_ORGANIZED = 'avon-park-unicast';
%DATA_ORGANIZED = 'avon-park-broadcast';
%DATA_ORGANIZED = 'testbed-40db-power-127';
%DATA_ORGANIZED = 'testbed-40db-power-128';
%DATA_ORGANIZED = 'kansei-broadcast';
%DATA_ORGANIZED = 'kansei-unicast';
%DATA_ORGANIZED = 'kansei-unicast-other-rows';
%DATA_ORGANIZED = 'kansei-mote-broadcast-power3';
%DATA_ORGANIZED = 'kansei-mote-broadcast-power6';
%DATA_ORGANIZED = 'kansei-mote-broadcast-power9';
%DATA_ORGANIZED = 'kansei-xsm-unicast-power3';
%DATA_ORGANIZED = 'kansei-xsm-broadcast-power3';
%DATA_ORGANIZED = 'kansei-xsm-broadcast-power2';
DATA_ORGANIZED = 'kansei-xsm-broadcast-power1';

POWER_LEVEL_TO_CONSIDER = 1;%1,2,3,6,9;

IS_FOR_MOTES = 1;
base_xy_loc = [14 3]; %[x y]: [14 3], [14 6]
HAS_TX_COUNT_DATA = 1; %0: no      1: yes

SENDER_TO_CONSIDER = 0;%65535;%55;%167;%113,167; %the node id of the sender
X_AS_Y_COORDINATE = 0; %1: yes     0: no        ; after kansei
if SENDER_TO_CONSIDER == 113 %Avon park: the location for 113 should have been <1,4>, instead of <4,1>
    x_dist_adjust = 3;
    y_dist_adjust = -3;
elseif IS_FOR_MOTES %minus the x- and y-coordinates of the base station respectively
    x_dist_adjust = -base_xy_loc(1);
    y_dist_adjust = -base_xy_loc(2);%-1;    
else 
    x_dist_adjust = 0;
    y_dist_adjust = 0;
end

ORGANIZED_FILE_NAME_INCLUDE_SUBDIR = 1; %1: yes;  0: no
%GRID_DIST = 45; %meters (since Avon-parkt)
GRID_DIST = 3/3.28; %kansei: 3 feet

HAS_MAC_LATENCY_DATA = 1; %0: no      1: yes     

DISTANCE_FILE = 'receiver-distance.txt';
SEND_FILE_PREFIX = 'lm_send.log-';
FB_FILE_PREFIX = 'lm_fb.log-';
RCV_FILE_PREFIX = 'lm_rcv.log-';

INVALID_FIELD = -3;

LOST_MARK = -4;
RECEIVED_MARK = 0;

STATUS_NOT_FOUND_MARK = -2; %Note: 1: success    -1: failure to receive ack   -2: not found
DISTANCE_NOT_FOUND_MARK = -1;

PROGRESS_REPORT_ITEMS = 5000;
PACK_MEM_ITEMS = 5000;

%get the set of subdirectories for individual sub-experiments
exptDirs = dir(rootDir);


%process each subdirectory: import data from each individual file, and
%merge them into a single big "table": link_data
for dirIndex = 1:length(exptDirs)
    indexedDir = exptDirs(dirIndex).name;
    %skip the directories ., .., backup, and done, as well as all the files
    if strcmp(indexedDir, '.') || strcmp(indexedDir, '..') || ...
            strcmp(indexedDir, 'backup') || strcmp(indexedDir, 'done') || ...
            ~exptDirs(dirIndex).isdir
        continue
    end
    disp(['Processing directory ' upper(indexedDir) ': please wait ...'])
    
    %get the files under this directory
    if ~USE_UNIX_MATLAB
        files = dir([rootDir '\' indexedDir]);
    else 
        files = dir([rootDir '/' indexedDir]);
    end
    
    
    %find the sender: the node whose "lm_send.log-..." is not empty    
    SENDER = [];
    for fileIndex = 1:length(files) 
        indexedFile = files(fileIndex).name;
        if files(fileIndex).isdir == 0 && ~isempty(strfind(indexedFile, SEND_FILE_PREFIX)) %is a file for send-log
            if ~USE_UNIX_MATLAB
                if ~IS_FOR_MOTES
                    content = load([rootDir '\' indexedDir '\' indexedFile]);
                else                    
                    content = load('-mat', [rootDir '\' indexedDir '\' indexedFile]);
                end
            else 
                if ~IS_FOR_MOTES
                    content = load([rootDir '/' indexedDir '/' indexedFile]);
                else                    
                    content = load('-mat', [rootDir '/' indexedDir '/' indexedFile]);
                end               
            end
            if ~isempty(content)
                %get the sender id and the sender log
                idStartPos = findstr(indexedFile, '-')+1;
                if idStartPos == length(indexedFile)
                    SENDER = str2num(indexedFile(length(indexedFile)));
                else
                    SENDER = str2num(indexedFile(idStartPos:length(indexedFile)));
                end
                if SENDER == SENDER_TO_CONSIDER
                    SEND_FILE = [SEND_FILE_PREFIX num2str(SENDER)];
                    FB_FILE = [FB_FILE_PREFIX num2str(SENDER)];
                    break
                else
                    SENDER = [];
                end
            end
            %to save memory
            clear content
        end
    end
    if isempty(SENDER)
        disp(['no sender, or the sender is not the one being considered; done with directory ' upper(indexedDir)]);
        continue;
    end
    
    disp(['     SENDER = ' num2str(SENDER)])
        
    %load the log file from the sender
    if ~USE_UNIX_MATLAB
        if ~IS_FOR_MOTES
            sender_log = load([rootDir '\' indexedDir '\' SEND_FILE]); %sender-id, seqNo, is-auto-rate, is-broadcast, pkt-size, sending-time
        else
            sender_log = load('-mat', [rootDir '\' indexedDir '\' SEND_FILE]);
            sender_log = sender_log.lm_send_log;
            sender_log = sender_log(find(sender_log(:, 7) == POWER_LEVEL_TO_CONSIDER), :);
        end
    else
        if ~IS_FOR_MOTES
            sender_log = load([rootDir '/' indexedDir '/' SEND_FILE]);
        else
            sender_log = load('-mat', [rootDir '/' indexedDir '/' SEND_FILE]);
            sender_log = sender_log.lm_send_log;
            %powers = sender_log(:, 7)
            %len_prev = size(sender_log, 1)
            sender_log = sender_log(find(sender_log(:, 7) == POWER_LEVEL_TO_CONSIDER), :);            
            %len_post = size(sender_log, 1)
        end
    end
    %     disp(['            sender-log: issorted = ' num2str(issorted(sender_log(:, 6)))]);
    %     if ~issorted(sender_log(:, 6))
    %         for i = 2:size(sender_log, 1)
    %             if sender_log(i-1, 6) > sender_log(i, 6)
    %                 disp(['sender-log unsorted at ' num2str(i) 'th item: ' num2str(sender_log(i-1, 6)) '>' num2str(sender_log(i, 6))]) ;
    %             end
    %         end
    %     end
    
    %load the MAC FEEDBACK file at the sender (i.e., node 71)
    if ~USE_UNIX_MATLAB
        if ~IS_FOR_MOTES
            mac_fb = load([rootDir '\' indexedDir '\' FB_FILE]); %# of feedback received, status, bitrate, feedback reception time, mac-latency
        else
            mac_fb = load('-mat', [rootDir '\' indexedDir '\' FB_FILE]);
            mac_fb = mac_fb.lm_fb_log; 
            mac_fb = mac_fb(find(mac_fb(:, 6) == POWER_LEVEL_TO_CONSIDER), :);
        end
    else 
        if ~IS_FOR_MOTES
            mac_fb = load([rootDir '/' indexedDir '/' FB_FILE]); 
        else
            mac_fb = load('-mat', [rootDir '/' indexedDir '/' FB_FILE]); 
            mac_fb = mac_fb.lm_fb_log;      
            mac_fb = mac_fb(find(mac_fb(:, 6) == POWER_LEVEL_TO_CONSIDER), :);
        end
    end
    
    %load the distance of the receiver from the sender
    if ~USE_UNIX_MATLAB
        distance_file = [rootDir '\' indexedDir '\' DISTANCE_FILE]; 
    else 
        distance_file = [rootDir '/' indexedDir '/' DISTANCE_FILE]; 
    end
    if exist(distance_file) ~= 0 % the distance-mapping file exists
        receiver_distance = load(distance_file); %receiver-id  distance(feet)        
    else
        receiver_distance = [];
        disp('     the file for manual receiver-distance mapping does not exist');
    end
    
    % process each individual file regarding receivers
    for fileIndex = 1:length(files) 
        numOfDataItems = 0; %the # of data items in table link_data
        indexedFile = files(fileIndex).name;
        %skip directories and files whose filename does not start with RCV_FILE_PREFIX
        if files(fileIndex).isdir == 1 || isempty(strfind(indexedFile, RCV_FILE_PREFIX))
            continue
        end
        
        %process the file regarding the reception state of a receiver
        disp(['   - processing file ' upper(indexedFile) ': please wait ...']);
        if ~USE_UNIX_MATLAB
            if ~IS_FOR_MOTES
                rcvData = load([rootDir '\' indexedDir '\' indexedFile]); 
            else
                rcvData = load('-mat', [rootDir '\' indexedDir '\' indexedFile]); 
                rcvData = rcvData.lm_rcv_log;
                rcvData = rcvData(find(rcvData(:, 13) == POWER_LEVEL_TO_CONSIDER), :);
            end
        else
            if ~IS_FOR_MOTES
                rcvData = load([rootDir '/' indexedDir '/' indexedFile]); 
            else
                rcvData = load('-mat', [rootDir '/' indexedDir '/' indexedFile]); 
                rcvData = rcvData.lm_rcv_log;
                %len_pre = length(rcvData)
                rcvData = rcvData(find(rcvData(:, 13) == POWER_LEVEL_TO_CONSIDER), :);
                %len_post = length(rcvData)
            end
        end
        %get the receiver id
        idStartPos = findstr(indexedFile, '-')+1;
        if idStartPos == length(indexedFile)
            receiver = str2num(indexedFile(length(indexedFile)));
        else
            receiver = str2num(indexedFile(idStartPos:length(indexedFile)));
        end
        disp(['                    receiver = ' num2str(receiver)]);
        
        %deal with receivers that did not receive any packet
        if isempty(rcvData) || (~IS_FOR_MOTES && isempty(find(rcvData(:, 2) == SENDER_TO_CONSIDER)))
            %skip if it is for the sender, who does not receive any packet
            if receiver == SENDER
                disp('         is the sender. Done!');
                continue
            end
            %search for the distance between the sender and the receiver
            if isempty(receiver_distance)
                disp('         no receiver-distance mapping. Done!');
                continue
            end
            distanceIndex = find(receiver_distance(:, 1) == receiver);
            if isempty(distanceIndex)
                warning(sprintf('Error: cannot find the distance for receiver %d', receiverId(numOfDataItems)));
                distanceFromSender = DISTANCE_NOT_FOUND_MARK;
            else
                distanceFromSender = receiver_distance(distanceIndex, 2); %get the distance
            end
            %Put in info regarding packets not received, via the SENDER_FILE;
            %depending on whether it is broadcast or unicast.
            if sender_log(1, 4) == 0 %is broadcast
                sent = sender_log;
            else 
                sent = sender_log(find(sender_log(:, 4) == receiver), :);
            end
            %disp(['         sent: issorted = ' num2str(issorted(sent(:, 6)))]);
            for itemIndex = 1:size(sent, 1) %process all the related log items
                numOfDataItems = numOfDataItems + 1;
                if mod(numOfDataItems, PROGRESS_REPORT_ITEMS) == 0
                    disp(['       numOfDataItems = ' num2str(numOfDataItems)]);
                end
                if mod(numOfDataItems, PACK_MEM_ITEMS) == 0
                    pack
                end           
                receiverId(numOfDataItems) = receiver;
                senderId(numOfDataItems) = sent(itemIndex, 1);
                seqNo(numOfDataItems) = sent(itemIndex, 2);
                isAutoRate(numOfDataItems) = sent(itemIndex, 3);
                isBroadcast(numOfDataItems) = sent(itemIndex, 4);
                pktSize(numOfDataItems) = sent(itemIndex, 5);
                receptionTime(numOfDataItems) = INVALID_FIELD;
                linkQuality(numOfDataItems) = INVALID_FIELD;
                signalLevel(numOfDataItems) = INVALID_FIELD;
                noiseLevel(numOfDataItems) = INVALID_FIELD;
                %note as not received
                isReceived(numOfDataItems) = LOST_MARK;
                %get the sending-time
                sendingTime(numOfDataItems) = sent(itemIndex, 6);
                %put in the distance
                receiverDist(numOfDataItems) = distanceFromSender;
                receiverDistX = []; receiverDistY = []; % for backward compatibility
                %search for the status information from the sender regarding this
                %packet received
                macFbIndex = find(mac_fb(:, 1) == seqNo(numOfDataItems));
                if IS_FOR_MOTES == 1
                    macFbIndex = intersect(macFbIndex, find(mac_fb(:, 8) == receiver)); %for the specific receiver
                end
                if isempty(macFbIndex)
                    warning(sprintf('cannot find the mac-feedback for the %d-th packet', seqNo(numOfDataItems)));
                    status(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                    bitrate(numOfDataItems) = STATUS_NOT_FOUND_MARK;                    
                    fbTime(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                    macLatency(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                    txCount(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                else
                    status(numOfDataItems) = mac_fb(macFbIndex, 2);
                    bitrate(numOfDataItems) = mac_fb(macFbIndex, 3);                    
                    fbTime(numOfDataItems) = mac_fb(macFbIndex, 4);
                    if HAS_MAC_LATENCY_DATA == 1
                        macLatency(numOfDataItems) = mac_fb(macFbIndex, 5);
                    end
                    if HAS_TX_COUNT_DATA == 1
                        txCount(numOfDataItems) = mac_fb(macFbIndex, 7);
                    end
                end
            end
            %save the organized data
            if isBroadcast(1) == 0
                type = 'broadcast';
            else 
                type = 'unicast';
            end
            %             if length(indexedDir) > 15
            %                 subDir = indexedDir(1:15);
            %             else
            %                 subDir = indexedDir;
            %             end
            subDir = indexedDir;
            if ORGANIZED_FILE_NAME_INCLUDE_SUBDIR == 1
                ORGANIZED_FILE_NAME = [DATA_ORGANIZED  '-' subDir '-' type '-' num2str(receiver) '.mat'];
            else
                ORGANIZED_FILE_NAME = [DATA_ORGANIZED  '-' type '-' num2str(receiver) '.mat'];
            end
            save(ORGANIZED_FILE_NAME, ...
                'receiverId', ...
                'senderId', ...
                'seqNo', ...
                'isAutoRate', ...
                'isBroadcast', ...
                'pktSize', ...
                'receptionTime', ...
                'linkQuality', ...
                'signalLevel', ...
                'noiseLevel', ...
                'receiverDist', ...
                'receiverDistX', ... % for backward compatibility
                'receiverDistY', ... % for backward compatibility
                'isReceived', ...
                'sendingTime', ...
                'status', ...
                'bitrate', ...
                'fbTime');
            if HAS_MAC_LATENCY_DATA == 1
                save(ORGANIZED_FILE_NAME, 'macLatency', '-append');
            end
            if HAS_TX_COUNT_DATA == 1
                save(ORGANIZED_FILE_NAME, 'txCount', '-append');
            end
            %to save memory 
            clear receiverId ...
                  senderId ...
                  seqNo ...
                  isAutoRate ...
                  isBroadcast ...
                  pktSize ...
                  receptionTime ...
                  linkQuality ...
                  signalLevel ...
                  noiseLevel ...
                  receiverDist ...
                  isReceived ...
                  sendingTime ...
                  status ...
                  bitrate ...
                  fbTime ...
                  macLatency ...
                  txCount;
            clear rcvData type; %to save memory 
            disp(['   done with file ' upper(indexedFile)]);
            continue
        end
        %now the file is not empty, process each data item;
        %Format for lm_rcv.log: 
        %   receiver-id/sender-id/pkt-seq-#/is-auto-bitrate/is-broadcast/pkt-size/reception-time/link-quality/signal-level/noise-level
        %   or (since Avon-park)
        %   receiver-id/sender-id/pkt-seq-#/is-auto-bitrate/is-broadcast/pkt-size/reception-time/x-dist/y-dist/link-quality/signal-level/noise-level

        %get the data regarding to the SENDER_TO_CONSIDER
        rcvData = rcvData(find(rcvData(:, 2) == SENDER_TO_CONSIDER), :);
        %get the log info that the sender has for the receiver
        dest = rcvData(1, 5); %field "is-broadcast"
        sent = sender_log(find(sender_log(:, 4) == dest), :);
        %sender_log(1, 4)
        %len_sender_log = size(sender_log, 1)
        %len_sent = length(sent)
        if isempty(sent)
            disp('         the sender does not have log for this receiver. Done!');
            continue;
        end
        %disp(['         sent: issorted = ' num2str(issorted(sent(:, 6)))]);
        
        %search for the distance between the sender and the receiver
        if isempty(receiver_distance) %since Avon-Park            
            x_dist = rcvData(1, 8) + x_dist_adjust; 
            y_dist = rcvData(1, 9) + y_dist_adjust; 
            distanceFromSender = sqrt(realpow(x_dist, 2) + realpow(y_dist, 2)) * GRID_DIST * 3.28; %feet
            %for testing link-distribution-symmetry
            if X_AS_Y_COORDINATE
                if x_dist < 0
                    distanceFromSender = -distanceFromSender;
                end
            else                
                if y_dist < 0
                    distanceFromSender = -distanceFromSender;
                end
            end
        else 
            distanceIndex = find(receiver_distance(:, 1) == receiver);
            if isempty(distanceIndex)
                warning(sprintf('Error: cannot find the distance for receiver %d', receiverId(numOfDataItems)));
                distanceFromSender = DISTANCE_NOT_FOUND_MARK;
            else
                distanceFromSender = receiver_distance(distanceIndex, 2); %get the distance
            end
            x_dist = DISTANCE_NOT_FOUND_MARK;
            y_dist = DISTANCE_NOT_FOUND_MARK;
        end
        
        %process info regarding each packet sent
        for sentIndex = 1:size(sent, 1) %length(sent)
            numOfDataItems = numOfDataItems + 1;
            if mod(numOfDataItems, PROGRESS_REPORT_ITEMS) == 0
                disp(['       numOfDataItems = ' num2str(numOfDataItems)]);
            end
            if mod(numOfDataItems, PACK_MEM_ITEMS) == 0
                pack
            end
            %check if the packet has been received, via seqNo
            rcvIndex = find(rcvData(:, 3) == sent(sentIndex, 2));
            if isempty(rcvIndex) %not received
                isReceived(numOfDataItems) = LOST_MARK; %mark as lost
                receiverId(numOfDataItems) = rcvData(1, 1);
                senderId(numOfDataItems) = sent(sentIndex, 1);
                seqNo(numOfDataItems) = sent(sentIndex, 2);
                isAutoRate(numOfDataItems) = sent(sentIndex, 3);
                isBroadcast(numOfDataItems) = sent(sentIndex, 4);
                pktSize(numOfDataItems) = sent(sentIndex, 5);
                receptionTime(numOfDataItems) = INVALID_FIELD;                
                linkQuality(numOfDataItems) = INVALID_FIELD;
                signalLevel(numOfDataItems) = INVALID_FIELD;
                noiseLevel(numOfDataItems) = INVALID_FIELD;
            else %is received   
                rcvIndex = rcvIndex(1); %to deal with duplicates
                isReceived(numOfDataItems) = RECEIVED_MARK; %mark as received
                receiverId(numOfDataItems) = rcvData(rcvIndex, 1);
                senderId(numOfDataItems) = rcvData(rcvIndex, 2);
                seqNo(numOfDataItems) = rcvData(rcvIndex, 3);
                isAutoRate(numOfDataItems) = rcvData(rcvIndex, 4);
                isBroadcast(numOfDataItems) = rcvData(rcvIndex, 5);
                pktSize(numOfDataItems) = rcvData(rcvIndex, 6);
                receptionTime(numOfDataItems) = rcvData(rcvIndex, 7);
                linkQuality(numOfDataItems) = rcvData(rcvIndex, 8);
                signalLevel(numOfDataItems) = rcvData(rcvIndex, 9);
                noiseLevel(numOfDataItems) = rcvData(rcvIndex, 10);
            end
            %record the sending-time           
            sendingTime(numOfDataItems) = sent(sentIndex, 6); 
            %put in the distance
            receiverDist(numOfDataItems) = distanceFromSender;
            receiverDistX(numOfDataItems) = x_dist;
            receiverDistY(numOfDataItems) = y_dist;
            %search for the status information from the sender regarding this
            %packet received
            macFbIndex = find(mac_fb(:, 1) == seqNo(numOfDataItems));
            if IS_FOR_MOTES == 1
                macFbIndex = intersect(macFbIndex, find(mac_fb(:, 8) == dest)); %for the specific receiver
                if length(macFbIndex) > 1
                    disp(['    ???: duplicate pkt/fb => length(macFbIndex) = ' num2str(length(macFbIndex))]);
                    macFbIndex = macFbIndex(1);
                end
            end
            if isempty(macFbIndex)
                %warning(sprintf('cannot find the mac-feedback for the %d-th packet', seqNo(numOfDataItems)));
                status(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                bitrate(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                fbTime(numOfDataItems) = STATUS_NOT_FOUND_MARK;               
                macLatency(numOfDataItems) = STATUS_NOT_FOUND_MARK;
                txCount(numOfDataItems) = STATUS_NOT_FOUND_MARK;
            else
                status(numOfDataItems) = mac_fb(macFbIndex, 2);
                bitrate(numOfDataItems) = mac_fb(macFbIndex, 3);
                fbTime(numOfDataItems) = mac_fb(macFbIndex, 4);
                if HAS_MAC_LATENCY_DATA == 1
                    macLatency(numOfDataItems) = mac_fb(macFbIndex, 5);
                end
                if HAS_TX_COUNT_DATA == 1
                    txCount(numOfDataItems) = mac_fb(macFbIndex, 7);
                end
            end
        end
        %save the organized data        
        if isBroadcast(1) == 0
            type = 'broadcast';
        else
            type = 'unicast';
        end
        %         if length(indexedDir) > 15
        %             subDir = indexedDir(1:15);
        %         else
        %             subDir = indexedDir;
        %         end
        subDir = indexedDir;
        if ORGANIZED_FILE_NAME_INCLUDE_SUBDIR == 1
            ORGANIZED_FILE_NAME = [DATA_ORGANIZED  '-' subDir '-' type '-' num2str(receiver) '.mat'];
        else
            ORGANIZED_FILE_NAME = [DATA_ORGANIZED  '-' type '-' num2str(receiver) '.mat'];
        end
        save(ORGANIZED_FILE_NAME, ...
            'receiverId', ...
            'senderId', ...
            'seqNo', ...
            'isAutoRate', ...
            'isBroadcast', ...
            'pktSize', ...
            'receptionTime', ...
            'linkQuality', ...
            'signalLevel', ...
            'noiseLevel', ...
            'receiverDist', ...
            'receiverDistX', ...
            'receiverDistY', ...
            'isReceived', ...
            'sendingTime', ...
            'status', ...
            'bitrate', ...
            'fbTime')
        if HAS_MAC_LATENCY_DATA == 1 
            save(ORGANIZED_FILE_NAME, 'macLatency', '-append');
        end
        if HAS_TX_COUNT_DATA == 1
            save(ORGANIZED_FILE_NAME, 'txCount', '-append');
        end
        %to save memory 
        clear receiverId ...
              senderId ...
              seqNo ...
              isAutoRate ...
              isBroadcast ...
              pktSize ...
              receptionTime ...
              linkQuality ...
              signalLevel ...
              noiseLevel ...
              receiverDist ...
              receiverDistX ...
              receiverDistY ...
              isReceived ...
              sendingTime ...
              status ...
              bitrate ...
              fbTime ...
              macLatency ...
              txCount;
        clear rcvData type;
        disp(['   done with file ' upper(indexedFile)]);
    end %files in a sub-directory
    disp(['done with directory ' upper(indexedDir)]);
end %sub-directories
        
disp('dataOrganizer: DONE!!!')
